package io.burkard.cdk.services.mediaconnect.cfnFlowOutput

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EncryptionProperty {

  def apply(
    secretArn: String,
    roleArn: String,
    keyType: Option[String] = None,
    algorithm: Option[String] = None
  ): software.amazon.awscdk.services.mediaconnect.CfnFlowOutput.EncryptionProperty =
    (new software.amazon.awscdk.services.mediaconnect.CfnFlowOutput.EncryptionProperty.Builder)
      .secretArn(secretArn)
      .roleArn(roleArn)
      .keyType(keyType.orNull)
      .algorithm(algorithm.orNull)
      .build()
}
