package io.burkard.cdk.services.lambda.eventsources

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object KafkaEventSourceProps {

  def apply(
    topic: String,
    secret: Option[software.amazon.awscdk.services.secretsmanager.ISecret] = None,
    batchSize: Option[Number] = None,
    enabled: Option[Boolean] = None,
    maxBatchingWindow: Option[software.amazon.awscdk.Duration] = None,
    startingPosition: Option[software.amazon.awscdk.services.lambda.StartingPosition] = None,
    onFailure: Option[software.amazon.awscdk.services.lambda.IEventSourceDlq] = None
  ): software.amazon.awscdk.services.lambda.eventsources.KafkaEventSourceProps =
    (new software.amazon.awscdk.services.lambda.eventsources.KafkaEventSourceProps.Builder)
      .topic(topic)
      .secret(secret.orNull)
      .batchSize(batchSize.orNull)
      .enabled(enabled.map(Boolean.box).orNull)
      .maxBatchingWindow(maxBatchingWindow.orNull)
      .startingPosition(startingPosition.orNull)
      .onFailure(onFailure.orNull)
      .build()
}
