package io.burkard.cdk.services.kinesisanalyticsv2.cfnApplicationOutput

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OutputProperty {

  def apply(
    destinationSchema: software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplicationOutput.DestinationSchemaProperty,
    name: Option[String] = None,
    lambdaOutput: Option[software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplicationOutput.LambdaOutputProperty] = None,
    kinesisStreamsOutput: Option[software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplicationOutput.KinesisStreamsOutputProperty] = None,
    kinesisFirehoseOutput: Option[software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplicationOutput.KinesisFirehoseOutputProperty] = None
  ): software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplicationOutput.OutputProperty =
    (new software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplicationOutput.OutputProperty.Builder)
      .destinationSchema(destinationSchema)
      .name(name.orNull)
      .lambdaOutput(lambdaOutput.orNull)
      .kinesisStreamsOutput(kinesisStreamsOutput.orNull)
      .kinesisFirehoseOutput(kinesisFirehoseOutput.orNull)
      .build()
}
