package io.burkard.cdk.services.kinesisanalyticsv2.cfnApplication

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ParallelismConfigurationProperty {

  def apply(
    configurationType: String,
    parallelism: Option[Number] = None,
    autoScalingEnabled: Option[Boolean] = None,
    parallelismPerKpu: Option[Number] = None
  ): software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.ParallelismConfigurationProperty =
    (new software.amazon.awscdk.services.kinesisanalyticsv2.CfnApplication.ParallelismConfigurationProperty.Builder)
      .configurationType(configurationType)
      .parallelism(parallelism.orNull)
      .autoScalingEnabled(autoScalingEnabled.map(Boolean.box).orNull)
      .parallelismPerKpu(parallelismPerKpu.orNull)
      .build()
}
