package io.burkard.cdk.services.iam

sealed abstract class AccessKeyStatus(val underlying: software.amazon.awscdk.services.iam.AccessKeyStatus)
  extends Product
    with Serializable

object AccessKeyStatus {
  implicit def toAws(value: AccessKeyStatus): software.amazon.awscdk.services.iam.AccessKeyStatus =
    Option(value).map(_.underlying).orNull

  case object Active
    extends AccessKeyStatus(software.amazon.awscdk.services.iam.AccessKeyStatus.ACTIVE)

  case object Inactive
    extends AccessKeyStatus(software.amazon.awscdk.services.iam.AccessKeyStatus.INACTIVE)
}
