package io.burkard.cdk.services.fsx

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LustreConfiguration {

  def apply(
    deploymentType: software.amazon.awscdk.services.fsx.LustreDeploymentType,
    perUnitStorageThroughput: Option[Number] = None,
    importedFileChunkSizeMiB: Option[Number] = None,
    weeklyMaintenanceStartTime: Option[software.amazon.awscdk.services.fsx.LustreMaintenanceTime] = None,
    importPath: Option[String] = None,
    exportPath: Option[String] = None
  ): software.amazon.awscdk.services.fsx.LustreConfiguration =
    (new software.amazon.awscdk.services.fsx.LustreConfiguration.Builder)
      .deploymentType(deploymentType)
      .perUnitStorageThroughput(perUnitStorageThroughput.orNull)
      .importedFileChunkSizeMiB(importedFileChunkSizeMiB.orNull)
      .weeklyMaintenanceStartTime(weeklyMaintenanceStartTime.orNull)
      .importPath(importPath.orNull)
      .exportPath(exportPath.orNull)
      .build()
}
