package io.burkard.cdk.services.frauddetector.cfnDetector

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OutcomeProperty {

  def apply(
    arn: Option[String] = None,
    name: Option[String] = None,
    lastUpdatedTime: Option[String] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    inline: Option[Boolean] = None,
    createdTime: Option[String] = None
  ): software.amazon.awscdk.services.frauddetector.CfnDetector.OutcomeProperty =
    (new software.amazon.awscdk.services.frauddetector.CfnDetector.OutcomeProperty.Builder)
      .arn(arn.orNull)
      .name(name.orNull)
      .lastUpdatedTime(lastUpdatedTime.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .inline(inline.map(Boolean.box).orNull)
      .createdTime(createdTime.orNull)
      .build()
}
