package io.burkard.cdk.services.frauddetector

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnEntityTypeProps {

  def apply(
    name: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    description: Option[String] = None
  ): software.amazon.awscdk.services.frauddetector.CfnEntityTypeProps =
    (new software.amazon.awscdk.services.frauddetector.CfnEntityTypeProps.Builder)
      .name(name)
      .tags(tags.map(_.asJava).orNull)
      .description(description.orNull)
      .build()
}
