package io.burkard.cdk.services.events

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OnEventOptions {

  def apply(
    target: Option[software.amazon.awscdk.services.events.IRuleTarget] = None,
    description: Option[String] = None,
    eventPattern: Option[software.amazon.awscdk.services.events.EventPattern] = None,
    ruleName: Option[String] = None
  ): software.amazon.awscdk.services.events.OnEventOptions =
    (new software.amazon.awscdk.services.events.OnEventOptions.Builder)
      .target(target.orNull)
      .description(description.orNull)
      .eventPattern(eventPattern.orNull)
      .ruleName(ruleName.orNull)
      .build()
}
