package io.burkard.cdk.services.ecs.patterns

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object NetworkLoadBalancerProps {

  def apply(
    name: String,
    listeners: List[_ <: software.amazon.awscdk.services.ecs.patterns.NetworkListenerProps],
    domainZone: Option[software.amazon.awscdk.services.route53.IHostedZone] = None,
    domainName: Option[String] = None,
    publicLoadBalancer: Option[Boolean] = None
  ): software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancerProps =
    (new software.amazon.awscdk.services.ecs.patterns.NetworkLoadBalancerProps.Builder)
      .name(name)
      .listeners(listeners.asJava)
      .domainZone(domainZone.orNull)
      .domainName(domainName.orNull)
      .publicLoadBalancer(publicLoadBalancer.map(Boolean.box).orNull)
      .build()
}
