package io.burkard.cdk.services.ec2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnVPCEndpointService {

  def apply(
    internalResourceId: String,
    acceptanceRequired: Option[Boolean] = None,
    payerResponsibility: Option[String] = None,
    gatewayLoadBalancerArns: Option[List[String]] = None,
    networkLoadBalancerArns: Option[List[String]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ec2.CfnVPCEndpointService =
    software.amazon.awscdk.services.ec2.CfnVPCEndpointService.Builder
      .create(stackCtx, internalResourceId)
      .acceptanceRequired(acceptanceRequired.map(Boolean.box).orNull)
      .payerResponsibility(payerResponsibility.orNull)
      .gatewayLoadBalancerArns(gatewayLoadBalancerArns.map(_.asJava).orNull)
      .networkLoadBalancerArns(networkLoadBalancerArns.map(_.asJava).orNull)
      .build()
}
