package io.burkard.cdk.services.appmesh

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ListenerTlsOptions {

  def apply(
    mode: software.amazon.awscdk.services.appmesh.TlsMode,
    certificate: software.amazon.awscdk.services.appmesh.TlsCertificate,
    mutualTlsValidation: Option[software.amazon.awscdk.services.appmesh.MutualTlsValidation] = None
  ): software.amazon.awscdk.services.appmesh.ListenerTlsOptions =
    (new software.amazon.awscdk.services.appmesh.ListenerTlsOptions.Builder)
      .mode(mode)
      .certificate(certificate)
      .mutualTlsValidation(mutualTlsValidation.orNull)
      .build()
}
