package io.burkard.cdk.services.applicationautoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ScalingInterval {

  def apply(
    change: Number,
    upper: Option[Number] = None,
    lower: Option[Number] = None
  ): software.amazon.awscdk.services.applicationautoscaling.ScalingInterval =
    (new software.amazon.awscdk.services.applicationautoscaling.ScalingInterval.Builder)
      .change(change)
      .upper(upper.orNull)
      .lower(lower.orNull)
      .build()
}
