package io.burkard.cdk.cloudassembly.schema

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object LoadBalancerFilter {

  def apply(
    loadBalancerType: software.amazon.awscdk.cloudassembly.schema.LoadBalancerType,
    loadBalancerTags: Option[List[_ <: software.amazon.awscdk.cloudassembly.schema.Tag]] = None,
    loadBalancerArn: Option[String] = None
  ): software.amazon.awscdk.cloudassembly.schema.LoadBalancerFilter =
    (new software.amazon.awscdk.cloudassembly.schema.LoadBalancerFilter.Builder)
      .loadBalancerType(loadBalancerType)
      .loadBalancerTags(loadBalancerTags.map(_.asJava).orNull)
      .loadBalancerArn(loadBalancerArn.orNull)
      .build()
}
