package io.burkard.cdk

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FileAssetLocation {

  def apply(
    bucketName: String,
    s3ObjectUrl: String,
    objectKey: String,
    httpUrl: String
  ): software.amazon.awscdk.FileAssetLocation =
    (new software.amazon.awscdk.FileAssetLocation.Builder)
      .bucketName(bucketName)
      .s3ObjectUrl(s3ObjectUrl)
      .objectKey(objectKey)
      .httpUrl(httpUrl)
      .build()
}
