package io.burkard.cdk.services.ssm

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnMaintenanceWindowTaskProps {

  def apply(
    priority: Number,
    windowId: String,
    taskArn: String,
    taskType: String,
    name: Option[String] = None,
    targets: Option[List[_]] = None,
    maxConcurrency: Option[String] = None,
    taskInvocationParameters: Option[software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask.TaskInvocationParametersProperty] = None,
    description: Option[String] = None,
    serviceRoleArn: Option[String] = None,
    cutoffBehavior: Option[String] = None,
    maxErrors: Option[String] = None,
    taskParameters: Option[AnyRef] = None,
    loggingInfo: Option[software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask.LoggingInfoProperty] = None
  ): software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTaskProps =
    (new software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTaskProps.Builder)
      .priority(priority)
      .windowId(windowId)
      .taskArn(taskArn)
      .taskType(taskType)
      .name(name.orNull)
      .targets(targets.map(_.asJava).orNull)
      .maxConcurrency(maxConcurrency.orNull)
      .taskInvocationParameters(taskInvocationParameters.orNull)
      .description(description.orNull)
      .serviceRoleArn(serviceRoleArn.orNull)
      .cutoffBehavior(cutoffBehavior.orNull)
      .maxErrors(maxErrors.orNull)
      .taskParameters(taskParameters.orNull)
      .loggingInfo(loggingInfo.orNull)
      .build()
}
