package io.burkard.cdk.services.ses

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnContactListProps {

  def apply(
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    description: Option[String] = None,
    contactListName: Option[String] = None,
    topics: Option[List[_]] = None
  ): software.amazon.awscdk.services.ses.CfnContactListProps =
    (new software.amazon.awscdk.services.ses.CfnContactListProps.Builder)
      .tags(tags.map(_.asJava).orNull)
      .description(description.orNull)
      .contactListName(contactListName.orNull)
      .topics(topics.map(_.asJava).orNull)
      .build()
}
