package io.burkard.cdk.services.nimblestudio

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnLaunchProfileProps {

  def apply(
    streamConfiguration: software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile.StreamConfigurationProperty,
    ec2SubnetIds: List[String],
    name: String,
    studioComponentIds: List[String],
    launchProfileProtocolVersions: List[String],
    studioId: String,
    description: Option[String] = None,
    tags: Option[Map[String, String]] = None
  ): software.amazon.awscdk.services.nimblestudio.CfnLaunchProfileProps =
    (new software.amazon.awscdk.services.nimblestudio.CfnLaunchProfileProps.Builder)
      .streamConfiguration(streamConfiguration)
      .ec2SubnetIds(ec2SubnetIds.asJava)
      .name(name)
      .studioComponentIds(studioComponentIds.asJava)
      .launchProfileProtocolVersions(launchProfileProtocolVersions.asJava)
      .studioId(studioId)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
