package io.burkard.cdk.services.logs

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ResourcePolicyProps {

  def apply(
    policyStatements: Option[List[_ <: software.amazon.awscdk.services.iam.PolicyStatement]] = None,
    resourcePolicyName: Option[String] = None
  ): software.amazon.awscdk.services.logs.ResourcePolicyProps =
    (new software.amazon.awscdk.services.logs.ResourcePolicyProps.Builder)
      .policyStatements(policyStatements.map(_.asJava).orNull)
      .resourcePolicyName(resourcePolicyName.orNull)
      .build()
}
