package io.burkard.cdk.services.location

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPlaceIndex {

  def apply(
    internalResourceId: String,
    dataSource: String,
    indexName: String,
    description: Option[String] = None,
    dataSourceConfiguration: Option[software.amazon.awscdk.services.location.CfnPlaceIndex.DataSourceConfigurationProperty] = None,
    pricingPlan: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.location.CfnPlaceIndex =
    software.amazon.awscdk.services.location.CfnPlaceIndex.Builder
      .create(stackCtx, internalResourceId)
      .dataSource(dataSource)
      .indexName(indexName)
      .description(description.orNull)
      .dataSourceConfiguration(dataSourceConfiguration.orNull)
      .pricingPlan(pricingPlan.orNull)
      .build()
}
