package io.burkard.cdk.services.lightsail

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDistribution {

  def apply(
    internalResourceId: String,
    bundleId: String,
    distributionName: String,
    origin: software.amazon.awscdk.services.lightsail.CfnDistribution.InputOriginProperty,
    defaultCacheBehavior: software.amazon.awscdk.services.lightsail.CfnDistribution.CacheBehaviorProperty,
    cacheBehaviorSettings: Option[software.amazon.awscdk.services.lightsail.CfnDistribution.CacheSettingsProperty] = None,
    cacheBehaviors: Option[List[_]] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    certificateName: Option[String] = None,
    ipAddressType: Option[String] = None,
    isEnabled: Option[Boolean] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.lightsail.CfnDistribution =
    software.amazon.awscdk.services.lightsail.CfnDistribution.Builder
      .create(stackCtx, internalResourceId)
      .bundleId(bundleId)
      .distributionName(distributionName)
      .origin(origin)
      .defaultCacheBehavior(defaultCacheBehavior)
      .cacheBehaviorSettings(cacheBehaviorSettings.orNull)
      .cacheBehaviors(cacheBehaviors.map(_.asJava).orNull)
      .tags(tags.map(_.asJava).orNull)
      .certificateName(certificateName.orNull)
      .ipAddressType(ipAddressType.orNull)
      .isEnabled(isEnabled.map(Boolean.box).orNull)
      .build()
}
