package io.burkard.cdk.services.lex.cfnBot

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object StillWaitingResponseSpecificationProperty {

  def apply(
    frequencyInSeconds: Number,
    messageGroupsList: List[_],
    timeoutInSeconds: Number,
    allowInterrupt: Option[Boolean] = None
  ): software.amazon.awscdk.services.lex.CfnBot.StillWaitingResponseSpecificationProperty =
    (new software.amazon.awscdk.services.lex.CfnBot.StillWaitingResponseSpecificationProperty.Builder)
      .frequencyInSeconds(frequencyInSeconds)
      .messageGroupsList(messageGroupsList.asJava)
      .timeoutInSeconds(timeoutInSeconds)
      .allowInterrupt(allowInterrupt.map(Boolean.box).orNull)
      .build()
}
