package io.burkard.cdk.services.lambda.eventsources

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BaseStreamEventSourceProps {

  def apply(
    startingPosition: software.amazon.awscdk.services.lambda.StartingPosition,
    batchSize: Option[Number] = None,
    enabled: Option[Boolean] = None,
    maxBatchingWindow: Option[software.amazon.awscdk.Duration] = None,
    onFailure: Option[software.amazon.awscdk.services.lambda.IEventSourceDlq] = None
  ): software.amazon.awscdk.services.lambda.eventsources.BaseStreamEventSourceProps =
    (new software.amazon.awscdk.services.lambda.eventsources.BaseStreamEventSourceProps.Builder)
      .startingPosition(startingPosition)
      .batchSize(batchSize.orNull)
      .enabled(enabled.map(Boolean.box).orNull)
      .maxBatchingWindow(maxBatchingWindow.orNull)
      .onFailure(onFailure.orNull)
      .build()
}
