package io.burkard.cdk.services.lakeformation

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPermissions {

  def apply(
    internalResourceId: String,
    resource: software.amazon.awscdk.services.lakeformation.CfnPermissions.ResourceProperty,
    dataLakePrincipal: software.amazon.awscdk.services.lakeformation.CfnPermissions.DataLakePrincipalProperty,
    permissions: Option[List[String]] = None,
    permissionsWithGrantOption: Option[List[String]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.lakeformation.CfnPermissions =
    software.amazon.awscdk.services.lakeformation.CfnPermissions.Builder
      .create(stackCtx, internalResourceId)
      .resource(resource)
      .dataLakePrincipal(dataLakePrincipal)
      .permissions(permissions.map(_.asJava).orNull)
      .permissionsWithGrantOption(permissionsWithGrantOption.map(_.asJava).orNull)
      .build()
}
