package io.burkard.cdk.services.iotevents.cfnDetectorModel

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EventProperty {

  def apply(
    eventName: String,
    actions: Option[List[_]] = None,
    condition: Option[String] = None
  ): software.amazon.awscdk.services.iotevents.CfnDetectorModel.EventProperty =
    (new software.amazon.awscdk.services.iotevents.CfnDetectorModel.EventProperty.Builder)
      .eventName(eventName)
      .actions(actions.map(_.asJava).orNull)
      .condition(condition.orNull)
      .build()
}
