package io.burkard.cdk.services.ecs

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnClusterCapacityProviderAssociationsProps {

  def apply(
    cluster: String,
    capacityProviders: List[String],
    defaultCapacityProviderStrategy: List[_]
  ): software.amazon.awscdk.services.ecs.CfnClusterCapacityProviderAssociationsProps =
    (new software.amazon.awscdk.services.ecs.CfnClusterCapacityProviderAssociationsProps.Builder)
      .cluster(cluster)
      .capacityProviders(capacityProviders.asJava)
      .defaultCapacityProviderStrategy(defaultCapacityProviderStrategy.asJava)
      .build()
}
