package io.burkard.cdk.services.databrew.cfnDataset

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object DatabaseInputDefinitionProperty {

  def apply(
    glueConnectionName: String,
    tempDirectory: Option[software.amazon.awscdk.services.databrew.CfnDataset.S3LocationProperty] = None,
    databaseTableName: Option[String] = None,
    queryString: Option[String] = None
  ): software.amazon.awscdk.services.databrew.CfnDataset.DatabaseInputDefinitionProperty =
    (new software.amazon.awscdk.services.databrew.CfnDataset.DatabaseInputDefinitionProperty.Builder)
      .glueConnectionName(glueConnectionName)
      .tempDirectory(tempDirectory.orNull)
      .databaseTableName(databaseTableName.orNull)
      .queryString(queryString.orNull)
      .build()
}
