package io.burkard.cdk.services.codecommit

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RepositoryTriggerOptions {

  def apply(
    name: Option[String] = None,
    events: Option[List[_ <: software.amazon.awscdk.services.codecommit.RepositoryEventTrigger]] = None,
    branches: Option[List[String]] = None,
    customData: Option[String] = None
  ): software.amazon.awscdk.services.codecommit.RepositoryTriggerOptions =
    (new software.amazon.awscdk.services.codecommit.RepositoryTriggerOptions.Builder)
      .name(name.orNull)
      .events(events.map(_.asJava).orNull)
      .branches(branches.map(_.asJava).orNull)
      .customData(customData.orNull)
      .build()
}
