package io.burkard.cdk.services.applicationautoscaling

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnScalableTargetProps {

  def apply(
    scalableDimension: String,
    resourceId: String,
    maxCapacity: Number,
    serviceNamespace: String,
    minCapacity: Number,
    roleArn: String,
    scheduledActions: Option[List[_]] = None,
    suspendedState: Option[software.amazon.awscdk.services.applicationautoscaling.CfnScalableTarget.SuspendedStateProperty] = None
  ): software.amazon.awscdk.services.applicationautoscaling.CfnScalableTargetProps =
    (new software.amazon.awscdk.services.applicationautoscaling.CfnScalableTargetProps.Builder)
      .scalableDimension(scalableDimension)
      .resourceId(resourceId)
      .maxCapacity(maxCapacity)
      .serviceNamespace(serviceNamespace)
      .minCapacity(minCapacity)
      .roleArn(roleArn)
      .scheduledActions(scheduledActions.map(_.asJava).orNull)
      .suspendedState(suspendedState.orNull)
      .build()
}
