package io.burkard.cdk.services.appflow.cfnConnectorProfile

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ZendeskConnectorProfileCredentialsProperty {

  def apply(
    clientId: String,
    clientSecret: String,
    accessToken: Option[String] = None,
    connectorOAuthRequest: Option[software.amazon.awscdk.services.appflow.CfnConnectorProfile.ConnectorOAuthRequestProperty] = None
  ): software.amazon.awscdk.services.appflow.CfnConnectorProfile.ZendeskConnectorProfileCredentialsProperty =
    (new software.amazon.awscdk.services.appflow.CfnConnectorProfile.ZendeskConnectorProfileCredentialsProperty.Builder)
      .clientId(clientId)
      .clientSecret(clientSecret)
      .accessToken(accessToken.orNull)
      .connectorOAuthRequest(connectorOAuthRequest.orNull)
      .build()
}
