package io.burkard.cdk

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object Tag {

  def apply(
    key: String,
    value: String,
    priority: Option[Number] = None,
    applyToLaunchedInstances: Option[Boolean] = None,
    excludeResourceTypes: Option[List[String]] = None,
    includeResourceTypes: Option[List[String]] = None
  ): software.amazon.awscdk.Tag =
    software.amazon.awscdk.Tag.Builder
      .create(key, value)
      .priority(priority.orNull)
      .applyToLaunchedInstances(applyToLaunchedInstances.map(Boolean.box).orNull)
      .excludeResourceTypes(excludeResourceTypes.map(_.asJava).orNull)
      .includeResourceTypes(includeResourceTypes.map(_.asJava).orNull)
      .build()
}
