package io.burkard.cdk

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object DockerBuildOptions {

  def apply(
    file: Option[String] = None,
    platform: Option[String] = None,
    buildArgs: Option[Map[String, String]] = None
  ): software.amazon.awscdk.DockerBuildOptions =
    (new software.amazon.awscdk.DockerBuildOptions.Builder)
      .file(file.orNull)
      .platform(platform.orNull)
      .buildArgs(buildArgs.map(_.asJava).orNull)
      .build()
}
