package io.burkard.cdk.services.wafv2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnWebACL {

  def apply(
    internalResourceId: String,
    visibilityConfig: software.amazon.awscdk.services.wafv2.CfnWebACL.VisibilityConfigProperty,
    scope: String,
    defaultAction: software.amazon.awscdk.services.wafv2.CfnWebACL.DefaultActionProperty,
    name: Option[String] = None,
    captchaConfig: Option[software.amazon.awscdk.services.wafv2.CfnWebACL.CaptchaConfigProperty] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    customResponseBodies: Option[Map[String, _]] = None,
    rules: Option[List[_]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.wafv2.CfnWebACL =
    software.amazon.awscdk.services.wafv2.CfnWebACL.Builder
      .create(stackCtx, internalResourceId)
      .visibilityConfig(visibilityConfig)
      .scope(scope)
      .defaultAction(defaultAction)
      .name(name.orNull)
      .captchaConfig(captchaConfig.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .customResponseBodies(customResponseBodies.map(_.asJava).orNull)
      .rules(rules.map(_.asJava).orNull)
      .build()
}
