package io.burkard.cdk.services.stepfunctions.tasks

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CommonEcsRunTaskProps {

  def apply(
    taskDefinition: software.amazon.awscdk.services.ecs.TaskDefinition,
    cluster: software.amazon.awscdk.services.ecs.ICluster,
    integrationPattern: Option[software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern] = None,
    containerOverrides: Option[List[_ <: software.amazon.awscdk.services.stepfunctions.tasks.ContainerOverride]] = None
  ): software.amazon.awscdk.services.stepfunctions.tasks.CommonEcsRunTaskProps =
    (new software.amazon.awscdk.services.stepfunctions.tasks.CommonEcsRunTaskProps.Builder)
      .taskDefinition(taskDefinition)
      .cluster(cluster)
      .integrationPattern(integrationPattern.orNull)
      .containerOverrides(containerOverrides.map(_.asJava).orNull)
      .build()
}
