package io.burkard.cdk.services.sns.subscriptions

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object UrlSubscription {

  def apply(
    url: String,
    protocol: Option[software.amazon.awscdk.services.sns.SubscriptionProtocol] = None,
    deadLetterQueue: Option[software.amazon.awscdk.services.sqs.IQueue] = None,
    filterPolicy: Option[Map[String, _ <: software.amazon.awscdk.services.sns.SubscriptionFilter]] = None,
    rawMessageDelivery: Option[Boolean] = None
  ): software.amazon.awscdk.services.sns.subscriptions.UrlSubscription =
    software.amazon.awscdk.services.sns.subscriptions.UrlSubscription.Builder
      .create(url)
      .protocol(protocol.orNull)
      .deadLetterQueue(deadLetterQueue.orNull)
      .filterPolicy(filterPolicy.map(_.asJava).orNull)
      .rawMessageDelivery(rawMessageDelivery.map(Boolean.box).orNull)
      .build()
}
