package io.burkard.cdk.services.sagemaker

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnModelPackageGroupProps {

  def apply(
    modelPackageGroupName: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    modelPackageGroupDescription: Option[String] = None,
    modelPackageGroupPolicy: Option[AnyRef] = None
  ): software.amazon.awscdk.services.sagemaker.CfnModelPackageGroupProps =
    (new software.amazon.awscdk.services.sagemaker.CfnModelPackageGroupProps.Builder)
      .modelPackageGroupName(modelPackageGroupName)
      .tags(tags.map(_.asJava).orNull)
      .modelPackageGroupDescription(modelPackageGroupDescription.orNull)
      .modelPackageGroupPolicy(modelPackageGroupPolicy.orNull)
      .build()
}
