package io.burkard.cdk.services.panorama

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPackageVersion {

  def apply(
    internalResourceId: String,
    packageVersion: String,
    patchVersion: String,
    packageId: String,
    updatedLatestPatchVersion: Option[String] = None,
    markLatest: Option[Boolean] = None,
    ownerAccount: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.panorama.CfnPackageVersion =
    software.amazon.awscdk.services.panorama.CfnPackageVersion.Builder
      .create(stackCtx, internalResourceId)
      .packageVersion(packageVersion)
      .patchVersion(patchVersion)
      .packageId(packageId)
      .updatedLatestPatchVersion(updatedLatestPatchVersion.orNull)
      .markLatest(markLatest.map(Boolean.box).orNull)
      .ownerAccount(ownerAccount.orNull)
      .build()
}
