package io.burkard.cdk.services.opensearchservice

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object Domain {

  def apply(
    internalResourceId: String,
    version: software.amazon.awscdk.services.opensearchservice.EngineVersion,
    tlsSecurityPolicy: Option[software.amazon.awscdk.services.opensearchservice.TLSSecurityPolicy] = None,
    useUnsignedBasicAuth: Option[Boolean] = None,
    zoneAwareness: Option[software.amazon.awscdk.services.opensearchservice.ZoneAwarenessConfig] = None,
    logging: Option[software.amazon.awscdk.services.opensearchservice.LoggingOptions] = None,
    customEndpoint: Option[software.amazon.awscdk.services.opensearchservice.CustomEndpointOptions] = None,
    nodeToNodeEncryption: Option[Boolean] = None,
    domainName: Option[String] = None,
    cognitoDashboardsAuth: Option[software.amazon.awscdk.services.opensearchservice.CognitoOptions] = None,
    vpcSubnets: Option[List[_ <: software.amazon.awscdk.services.ec2.SubnetSelection]] = None,
    automatedSnapshotStartHour: Option[Number] = None,
    ebs: Option[software.amazon.awscdk.services.opensearchservice.EbsOptions] = None,
    fineGrainedAccessControl: Option[software.amazon.awscdk.services.opensearchservice.AdvancedSecurityOptions] = None,
    accessPolicies: Option[List[_ <: software.amazon.awscdk.services.iam.PolicyStatement]] = None,
    enableVersionUpgrade: Option[Boolean] = None,
    securityGroups: Option[List[_ <: software.amazon.awscdk.services.ec2.ISecurityGroup]] = None,
    vpc: Option[software.amazon.awscdk.services.ec2.IVpc] = None,
    enforceHttps: Option[Boolean] = None,
    encryptionAtRest: Option[software.amazon.awscdk.services.opensearchservice.EncryptionAtRestOptions] = None,
    advancedOptions: Option[Map[String, String]] = None,
    removalPolicy: Option[software.amazon.awscdk.RemovalPolicy] = None,
    capacity: Option[software.amazon.awscdk.services.opensearchservice.CapacityConfig] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.opensearchservice.Domain =
    software.amazon.awscdk.services.opensearchservice.Domain.Builder
      .create(stackCtx, internalResourceId)
      .version(version)
      .tlsSecurityPolicy(tlsSecurityPolicy.orNull)
      .useUnsignedBasicAuth(useUnsignedBasicAuth.map(Boolean.box).orNull)
      .zoneAwareness(zoneAwareness.orNull)
      .logging(logging.orNull)
      .customEndpoint(customEndpoint.orNull)
      .nodeToNodeEncryption(nodeToNodeEncryption.map(Boolean.box).orNull)
      .domainName(domainName.orNull)
      .cognitoDashboardsAuth(cognitoDashboardsAuth.orNull)
      .vpcSubnets(vpcSubnets.map(_.asJava).orNull)
      .automatedSnapshotStartHour(automatedSnapshotStartHour.orNull)
      .ebs(ebs.orNull)
      .fineGrainedAccessControl(fineGrainedAccessControl.orNull)
      .accessPolicies(accessPolicies.map(_.asJava).orNull)
      .enableVersionUpgrade(enableVersionUpgrade.map(Boolean.box).orNull)
      .securityGroups(securityGroups.map(_.asJava).orNull)
      .vpc(vpc.orNull)
      .enforceHttps(enforceHttps.map(Boolean.box).orNull)
      .encryptionAtRest(encryptionAtRest.orNull)
      .advancedOptions(advancedOptions.map(_.asJava).orNull)
      .removalPolicy(removalPolicy.orNull)
      .capacity(capacity.orNull)
      .build()
}
