package io.burkard.cdk.services.nimblestudio.cfnLaunchProfile

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object StreamConfigurationProperty {

  def apply(
    ec2InstanceTypes: List[String],
    streamingImageIds: List[String],
    clipboardMode: String,
    sessionStorage: Option[software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile.StreamConfigurationSessionStorageProperty] = None,
    maxStoppedSessionLengthInMinutes: Option[Number] = None,
    maxSessionLengthInMinutes: Option[Number] = None
  ): software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile.StreamConfigurationProperty =
    (new software.amazon.awscdk.services.nimblestudio.CfnLaunchProfile.StreamConfigurationProperty.Builder)
      .ec2InstanceTypes(ec2InstanceTypes.asJava)
      .streamingImageIds(streamingImageIds.asJava)
      .clipboardMode(clipboardMode)
      .sessionStorage(sessionStorage.orNull)
      .maxStoppedSessionLengthInMinutes(maxStoppedSessionLengthInMinutes.orNull)
      .maxSessionLengthInMinutes(maxSessionLengthInMinutes.orNull)
      .build()
}
