package io.burkard.cdk.services.lex.cfnBot

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object KendraConfigurationProperty {

  def apply(
    kendraIndex: String,
    queryFilterString: Option[String] = None,
    queryFilterStringEnabled: Option[Boolean] = None
  ): software.amazon.awscdk.services.lex.CfnBot.KendraConfigurationProperty =
    (new software.amazon.awscdk.services.lex.CfnBot.KendraConfigurationProperty.Builder)
      .kendraIndex(kendraIndex)
      .queryFilterString(queryFilterString.orNull)
      .queryFilterStringEnabled(queryFilterStringEnabled.map(Boolean.box).orNull)
      .build()
}
