package io.burkard.cdk.services.globalaccelerator.cfnEndpointGroup

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EndpointConfigurationProperty {

  def apply(
    endpointId: String,
    clientIpPreservationEnabled: Option[Boolean] = None,
    weight: Option[Number] = None
  ): software.amazon.awscdk.services.globalaccelerator.CfnEndpointGroup.EndpointConfigurationProperty =
    (new software.amazon.awscdk.services.globalaccelerator.CfnEndpointGroup.EndpointConfigurationProperty.Builder)
      .endpointId(endpointId)
      .clientIpPreservationEnabled(clientIpPreservationEnabled.map(Boolean.box).orNull)
      .weight(weight.orNull)
      .build()
}
