package io.burkard.cdk.services.emr.cfnInstanceGroupConfig

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ScalingRuleProperty {

  def apply(
    name: String,
    trigger: software.amazon.awscdk.services.emr.CfnInstanceGroupConfig.ScalingTriggerProperty,
    action: software.amazon.awscdk.services.emr.CfnInstanceGroupConfig.ScalingActionProperty,
    description: Option[String] = None
  ): software.amazon.awscdk.services.emr.CfnInstanceGroupConfig.ScalingRuleProperty =
    (new software.amazon.awscdk.services.emr.CfnInstanceGroupConfig.ScalingRuleProperty.Builder)
      .name(name)
      .trigger(trigger)
      .action(action)
      .description(description.orNull)
      .build()
}
