package io.burkard.cdk.services.eks

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AlbController {

  def apply(
    internalResourceId: String,
    cluster: software.amazon.awscdk.services.eks.Cluster,
    version: Option[software.amazon.awscdk.services.eks.AlbControllerVersion] = None,
    policy: Option[AnyRef] = None,
    repository: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.eks.AlbController =
    software.amazon.awscdk.services.eks.AlbController.Builder
      .create(stackCtx, internalResourceId)
      .cluster(cluster)
      .version(version.orNull)
      .policy(policy.orNull)
      .repository(repository.orNull)
      .build()
}
