package io.burkard.cdk.services.ecs

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object DockerVolumeConfiguration {

  def apply(
    scope: software.amazon.awscdk.services.ecs.Scope,
    driver: String,
    autoprovision: Option[Boolean] = None,
    labels: Option[Map[String, String]] = None,
    driverOpts: Option[Map[String, String]] = None
  ): software.amazon.awscdk.services.ecs.DockerVolumeConfiguration =
    (new software.amazon.awscdk.services.ecs.DockerVolumeConfiguration.Builder)
      .scope(scope)
      .driver(driver)
      .autoprovision(autoprovision.map(Boolean.box).orNull)
      .labels(labels.map(_.asJava).orNull)
      .driverOpts(driverOpts.map(_.asJava).orNull)
      .build()
}
