package io.burkard.cdk.services.databrew.cfnDataset

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object InputProperty {

  def apply(
    databaseInputDefinition: Option[software.amazon.awscdk.services.databrew.CfnDataset.DatabaseInputDefinitionProperty] = None,
    dataCatalogInputDefinition: Option[software.amazon.awscdk.services.databrew.CfnDataset.DataCatalogInputDefinitionProperty] = None,
    s3InputDefinition: Option[software.amazon.awscdk.services.databrew.CfnDataset.S3LocationProperty] = None,
    metadata: Option[software.amazon.awscdk.services.databrew.CfnDataset.MetadataProperty] = None
  ): software.amazon.awscdk.services.databrew.CfnDataset.InputProperty =
    (new software.amazon.awscdk.services.databrew.CfnDataset.InputProperty.Builder)
      .databaseInputDefinition(databaseInputDefinition.orNull)
      .dataCatalogInputDefinition(dataCatalogInputDefinition.orNull)
      .s3InputDefinition(s3InputDefinition.orNull)
      .metadata(metadata.orNull)
      .build()
}
