package io.burkard.cdk.services.config

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDeliveryChannel {

  def apply(
    internalResourceId: String,
    s3BucketName: String,
    name: Option[String] = None,
    s3KmsKeyArn: Option[String] = None,
    configSnapshotDeliveryProperties: Option[software.amazon.awscdk.services.config.CfnDeliveryChannel.ConfigSnapshotDeliveryPropertiesProperty] = None,
    snsTopicArn: Option[String] = None,
    s3KeyPrefix: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.config.CfnDeliveryChannel =
    software.amazon.awscdk.services.config.CfnDeliveryChannel.Builder
      .create(stackCtx, internalResourceId)
      .s3BucketName(s3BucketName)
      .name(name.orNull)
      .s3KmsKeyArn(s3KmsKeyArn.orNull)
      .configSnapshotDeliveryProperties(configSnapshotDeliveryProperties.orNull)
      .snsTopicArn(snsTopicArn.orNull)
      .s3KeyPrefix(s3KeyPrefix.orNull)
      .build()
}
