package io.burkard.cdk.services.codepipeline.actions

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CodeCommitSourceAction {

  def apply(
    repository: software.amazon.awscdk.services.codecommit.IRepository,
    output: software.amazon.awscdk.services.codepipeline.Artifact,
    codeBuildCloneOutput: Option[Boolean] = None,
    eventRole: Option[software.amazon.awscdk.services.iam.IRole] = None,
    role: Option[software.amazon.awscdk.services.iam.IRole] = None,
    branch: Option[String] = None,
    variablesNamespace: Option[String] = None,
    runOrder: Option[Number] = None,
    actionName: Option[String] = None,
    trigger: Option[software.amazon.awscdk.services.codepipeline.actions.CodeCommitTrigger] = None
  ): software.amazon.awscdk.services.codepipeline.actions.CodeCommitSourceAction =
    software.amazon.awscdk.services.codepipeline.actions.CodeCommitSourceAction.Builder
      .create()
      .repository(repository)
      .output(output)
      .codeBuildCloneOutput(codeBuildCloneOutput.map(Boolean.box).orNull)
      .eventRole(eventRole.orNull)
      .role(role.orNull)
      .branch(branch.orNull)
      .variablesNamespace(variablesNamespace.orNull)
      .runOrder(runOrder.orNull)
      .actionName(actionName.orNull)
      .trigger(trigger.orNull)
      .build()
}
