package io.burkard.cdk.services.codedeploy

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDeploymentConfig {

  def apply(
    internalResourceId: String,
    trafficRoutingConfig: Option[software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.TrafficRoutingConfigProperty] = None,
    computePlatform: Option[String] = None,
    deploymentConfigName: Option[String] = None,
    minimumHealthyHosts: Option[software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.MinimumHealthyHostsProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig =
    software.amazon.awscdk.services.codedeploy.CfnDeploymentConfig.Builder
      .create(stackCtx, internalResourceId)
      .trafficRoutingConfig(trafficRoutingConfig.orNull)
      .computePlatform(computePlatform.orNull)
      .deploymentConfigName(deploymentConfigName.orNull)
      .minimumHealthyHosts(minimumHealthyHosts.orNull)
      .build()
}
