package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RequestCountScalingProps {

  def apply(
    cooldown: Option[software.amazon.awscdk.Duration] = None,
    disableScaleIn: Option[Boolean] = None,
    estimatedInstanceWarmup: Option[software.amazon.awscdk.Duration] = None,
    targetRequestsPerMinute: Option[Number] = None
  ): software.amazon.awscdk.services.autoscaling.RequestCountScalingProps =
    (new software.amazon.awscdk.services.autoscaling.RequestCountScalingProps.Builder)
      .cooldown(cooldown.orNull)
      .disableScaleIn(disableScaleIn.map(Boolean.box).orNull)
      .estimatedInstanceWarmup(estimatedInstanceWarmup.orNull)
      .targetRequestsPerMinute(targetRequestsPerMinute.orNull)
      .build()
}
