package io.burkard.cdk.services.athena

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnWorkGroupProps {

  def apply(
    name: String,
    state: Option[String] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    workGroupConfiguration: Option[software.amazon.awscdk.services.athena.CfnWorkGroup.WorkGroupConfigurationProperty] = None,
    workGroupConfigurationUpdates: Option[software.amazon.awscdk.services.athena.CfnWorkGroup.WorkGroupConfigurationUpdatesProperty] = None,
    recursiveDeleteOption: Option[Boolean] = None
  ): software.amazon.awscdk.services.athena.CfnWorkGroupProps =
    (new software.amazon.awscdk.services.athena.CfnWorkGroupProps.Builder)
      .name(name)
      .state(state.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .workGroupConfiguration(workGroupConfiguration.orNull)
      .workGroupConfigurationUpdates(workGroupConfigurationUpdates.orNull)
      .recursiveDeleteOption(recursiveDeleteOption.map(Boolean.box).orNull)
      .build()
}
